define(['angular', 'app'], function (angular, app) {
    "use strict";
    app.service('FitnessRemindersService', function ($q, FitnessRemindersInstanceService) {

        var FitnessRemindersService = {},
            remindersService,
            key,
            section;

        FitnessRemindersService.init = function(instanceKey) {
            remindersService = FitnessRemindersInstanceService.instance(instanceKey + "-reminders");
            key = instanceKey;
            section = 'Fitness Activity';
        };

        FitnessRemindersService.getReminder = function() {
            var defer = $q.defer();

            remindersService.fetch().then(function(response) {
                if(response.size === 0) {
                    defer.resolve(remindersService.createEmpty());
                } else {
                    defer.resolve(response.reminders[0]);
                }
            }, function(error) {
                defer.reject(error);
            });

            return defer.promise;
        };

        FitnessRemindersService.save = function(reminder) {
            reminder.title = "Update your " + section + " information now.";
            if (reminder.notificationStatus == "On") {
                reminder.healthTrackerId = key;
                reminder.auxData = createReminderAuxData();
            }

            //2/16/2017 - Notification Services 2.3.0 added required field 'reminderClass' that is
            //just the frequency plus 'Reminder' e.g. WeeklyReminder, DailyReminder, MonthyReminder
            reminder.reminderClass = reminder.frequency + "Reminder";

            var defer = $q.defer();

            remindersService.save(reminder).then(function() {
                defer.resolve();
            }, function(error){
                defer.reject(error);
            });

            return defer.promise;
        };

        function createReminderAuxData() {
            var subject = "Update your " + section + " information now.";

            var body = "<br/>This notice is provided to help you remember to update your " +
                section + " information.<br/><br/>";

            var updateMsg = "Update this information in the {appLink}<br/><br/>" +
                "To modify or stop future notices, update the Notification settings for " +
                section + " inside the VA FitHeart App.";

            return [
                {key: "emailSubject", value: subject},
                {key: "emailBody", value: body},
                {key: "emailUpdateMessage", value: updateMsg},
                {key: 'emailSignature', value: 'VA FitHeart - Health'},
                {key: 'source', value: 'FIT_HEART'},
                {key: 'appName', value:  'fit-heart'},
                {key: 'appUri', value: 'fit-heart'}

            ];
        }

        return FitnessRemindersService;
    });
});
